/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher;

import ar.edu.unicen.isistan.si.soploon.server.models.Configuration;
import ar.edu.unicen.isistan.si.soploon.server.models.Correction;
import ar.edu.unicen.isistan.si.soploon.server.models.Project;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.api.Synchronizer;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.eclipse.views.CorrectionsView;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.storage.CorrectionData;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.storage.StorageManager;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.PrologAnalyzer;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.bugs.Bug;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.ModelGenerator;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.parser.CodeParser;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Teacher {
    public static final String LOG_PATH = (String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "dropins" + File.separator + "plugins" + File.separator + "runs" + File.separator).substring(1);
    private static final String ERROR_MESSAGE_X0 = "Error en el Proyecto";
    private static final String ERROR_MESSAGE_X1 = "Error generando el Modelo Prolog";
    private static final String ERROR_MESSAGE_X2 = "Error generando el AST";
    private static final String ERROR_MESSAGE_X3 = "Error corrigiendo el Modelo Prolog";
    private static Teacher TEACHER = null;
    private CodeParser codeParser = new CodeParser();
    private PrologAnalyzer prologAnalyzer = new PrologAnalyzer();
    private ModelGenerator modelGenerator = new ModelGenerator();
    private IJavaProject project = null;

    public static Teacher getInstance() {
        if (TEACHER == null) {
            TEACHER = new Teacher();
        }
        return TEACHER;
    }

    private Teacher() {
    }

    public PrologAnalyzer getAnalyzer() {
        return this.prologAnalyzer;
    }

    public void check(IJavaProject project) {
        this.project = project;
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(new Shell());
            CorrectionsView view = (CorrectionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("TeachingAssistant.corrections");
            CheckRunnable runner = new CheckRunnable(project, this.codeParser, this.prologAnalyzer, this.modelGenerator);
            dialog.run(true, true, (IRunnableWithProgress)runner);
            int result = runner.getResult();
            if (result == 0) {
                view.setBugs(runner.getBugs());
            } else if (result < 0) {
                String message = null;
                switch (runner.getResult()) {
                    case -1: {
                        message = ERROR_MESSAGE_X0;
                        break;
                    }
                    case -2: {
                        message = ERROR_MESSAGE_X1;
                        break;
                    }
                    case -3: {
                        message = ERROR_MESSAGE_X2;
                        break;
                    }
                    case -4: {
                        message = ERROR_MESSAGE_X3;
                    }
                }
                MessageDialog.openInformation(null, (String)"Ayudante Virtual", (String)message);
            }
            this.store();
            new Thread(Synchronizer.getInstance()::sync).start();
        }
        catch (InterruptedException | InvocationTargetException | PartInitException e) {
            e.printStackTrace();
        }
    }

    private Configuration currentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setVersion("2.0");
        configuration.setRules(this.prologAnalyzer.rulesVersions());
        configuration.setPredicates(this.prologAnalyzer.predicatesVersions());
        return configuration;
    }

    private void store() {
        CorrectionData data = new CorrectionData();
        Project project = new Project();
        project.setName(this.project.getJavaProject().getElementName());
        data.setProject(project);
        Correction correction = new Correction();
        correction.setRepresentation(this.modelGenerator.toRepresentation());
        correction.setCode(this.codeParser.toSourceCodes());
        correction.setConfiguration(this.currentConfiguration());
        data.setCorrection(correction);
        data.setErrors(this.prologAnalyzer.toErrors());
        StorageManager storageManager = StorageManager.getInstance();
        storageManager.store(data);
    }

    private class CheckRunnable
    implements IRunnableWithProgress {
        private IJavaProject project;
        private CodeParser codeParser;
        private PrologAnalyzer prologAnalyzer;
        private ModelGenerator modelGenerator;
        private List<Bug> bugs;
        private int result;

        public CheckRunnable(IJavaProject project, CodeParser codeParser, PrologAnalyzer prologAnalyzer, ModelGenerator modelGenerator) {
            this.project = project;
            this.codeParser = codeParser;
            this.prologAnalyzer = prologAnalyzer;
            this.modelGenerator = modelGenerator;
            this.bugs = new Vector<Bug>();
        }

        public List<Bug> getBugs() {
            return this.bugs;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IPackageFragment[] packages = this.project.getPackageFragments();
                Vector<IPackageFragment> packages_source = new Vector<IPackageFragment>();
                IPackageFragment[] iPackageFragmentArray = packages;
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment actual_package = iPackageFragmentArray[n2];
                    if (actual_package.getKind() == 1) {
                        packages_source.add(actual_package);
                    }
                    ++n2;
                }
                this.result = this.codeParser.process(this.project, monitor) * 2;
                if (this.result != 0) {
                    return;
                }
                this.result = this.modelGenerator.process(this.codeParser.getUnits(), monitor) * 3;
                if (this.result != 0) {
                    return;
                }
                this.result = this.prologAnalyzer.process(this.modelGenerator.getMapper(), this.modelGenerator.getPrologCode(), this.modelGenerator.getFactory(), monitor) * 4;
                if (this.result != 0) {
                    return;
                }
                this.bugs.addAll(this.prologAnalyzer.getBugs());
                monitor.done();
            }
            catch (CoreException coreException) {
                monitor.done();
                this.result = -1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getResult() {
            return this.result;
        }
    }
}

