/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;

public class ExpressionMethodReferencePrologConverter
extends NodeConverter<ExpressionMethodReference> {
    private static final String KEY = "expression_method_reference";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[2] = "expression";
        stringArray[3] = "method";
        stringArray[4] = "arguments";
        stringArray[5] = "body_declaration";
        stringArray[6] = "type_declaration";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    public ExpressionMethodReferencePrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(ExpressionMethodReference node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String method = this.mapper.getBindingID((IBinding)node.resolveMethodBinding());
        this.converter_factory.getConverter((ASTNode)node.getExpression()).convert(node.getExpression());
        String expression_id = this.mapper.getNodeID((ASTNode)node.getExpression());
        Vector<ASTNode> arguments_nodes = new Vector<ASTNode>();
        arguments_nodes.addAll(node.typeArguments());
        for (ASTNode argument : arguments_nodes) {
            this.converter_factory.getConverter(argument).convert(argument);
        }
        String arguments = this.generateList(arguments_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, expression_id, method, arguments, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(ExpressionMethodReference node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getExpression()).bind(node.getExpression());
        Vector arguments_nodes = new Vector();
        arguments_nodes.addAll(node.typeArguments());
        for (ASTNode argument : arguments_nodes) {
            this.converter_factory.getConverter(argument).bind(argument);
        }
    }
}

