/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class CompilationUnitPrologConverter
extends NodeConverter<CompilationUnit> {
    private static final String KEY = "compilation_unit";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[6];
        stringArray[2] = "path";
        stringArray[3] = "package";
        stringArray[4] = "imports";
        stringArray[5] = "types";
        KEYS = stringArray;
    }

    protected CompilationUnitPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(CompilationUnit node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String name = this.quote(node.getJavaElement().getElementName().toString());
        String path = this.quote(node.getJavaElement().getPath().toString());
        String package_id = null;
        if (node.getPackage() != null) {
            this.converter_factory.getConverter((ASTNode)node.getPackage()).convert(node.getPackage());
            package_id = this.mapper.getNodeID((ASTNode)node.getPackage());
        }
        Vector<ASTNode> import_nodes = new Vector<ASTNode>();
        import_nodes.addAll(node.imports());
        for (ASTNode import_node : import_nodes) {
            this.converter_factory.getConverter(import_node).convert(import_node);
        }
        String imports = this.generateList(import_nodes);
        Vector<ASTNode> types_nodes = new Vector<ASTNode>();
        types_nodes.addAll(node.types());
        for (ASTNode type : types_nodes) {
            this.converter_factory.getConverter(type).convert(type);
        }
        String types = this.generateList(types_nodes);
        String[] args = new String[]{id, name, path, package_id, imports, types};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(CompilationUnit node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        if (node.getPackage() != null) {
            this.converter_factory.getConverter((ASTNode)node.getPackage()).bind(node.getPackage());
        }
        Vector import_nodes = new Vector();
        import_nodes.addAll(node.imports());
        for (ASTNode import_node : import_nodes) {
            this.converter_factory.getConverter(import_node).bind(import_node);
        }
        Vector types_nodes = new Vector();
        types_nodes.addAll(node.types());
        for (ASTNode type : types_nodes) {
            this.converter_factory.getConverter(type).bind(type);
        }
    }
}

