/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class EnumConstantDeclarationPrologConverter
extends NodeConverter<EnumConstantDeclaration> {
    private static final String KEY = "enum_constant_declaration";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[7];
        stringArray[1] = "parent";
        stringArray[3] = "modifiers";
        stringArray[4] = "arguments";
        stringArray[5] = "anonymous_class";
        stringArray[6] = "compilation_unit";
        KEYS = stringArray;
    }

    public EnumConstantDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(EnumConstantDeclaration node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String name = this.quote(node.getName().toString());
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        Vector<ASTNode> arguments_nodes = new Vector<ASTNode>();
        arguments_nodes.addAll(node.arguments());
        for (ASTNode argument : arguments_nodes) {
            this.converter_factory.getConverter(argument).convert(argument);
        }
        String arguments = this.generateList(arguments_nodes);
        String anonymous_class_id = null;
        if (node.getAnonymousClassDeclaration() != null) {
            this.converter_factory.getConverter((ASTNode)node.getAnonymousClassDeclaration()).convert(node.getAnonymousClassDeclaration());
            anonymous_class_id = this.mapper.getNodeID((ASTNode)node.getAnonymousClassDeclaration());
        }
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, name, modifiers, arguments, anonymous_class_id, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(EnumConstantDeclaration node) {
        this.mapper.setBindingID((IBinding)node.resolveVariable(), this.mapper.getNodeID((ASTNode)node));
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        Vector arguments_nodes = new Vector();
        arguments_nodes.addAll(node.arguments());
        for (ASTNode argument : arguments_nodes) {
            this.converter_factory.getConverter(argument).bind(argument);
        }
        if (node.getAnonymousClassDeclaration() != null) {
            this.converter_factory.getConverter((ASTNode)node.getAnonymousClassDeclaration()).bind(node.getAnonymousClassDeclaration());
        }
    }

    @Override
    public String getName(TypeDeclaration node) {
        return node.getName().toString();
    }
}

