/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class FieldDeclarationPrologConverter
extends NodeConverter<FieldDeclaration> {
    private static final String KEY = "field_declaration";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[3] = "type";
        stringArray[4] = "modifiers";
        stringArray[5] = "extra_dimensions";
        stringArray[6] = "initializer";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    public FieldDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(FieldDeclaration node) {
        String parent = this.mapper.getNodeID(node.getParent());
        this.converter_factory.getConverter((ASTNode)node.getType()).convert(node.getType());
        String type = this.mapper.getNodeID((ASTNode)node.getType());
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        String unit = this.mapper.getNodeID(node.getRoot());
        Vector<ASTNode> fragments_nodes = new Vector<ASTNode>();
        fragments_nodes.addAll(node.fragments());
        for (ASTNode aux : fragments_nodes) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)aux;
            this.converter_factory.getConverter((ASTNode)fragment).convert(fragment);
            String id = this.mapper.getNodeID((ASTNode)fragment);
            String name = this.quote(fragment.getName().toString());
            String extra_dimensions = Integer.toString(fragment.getExtraDimensions());
            String initializer = null;
            if (fragment.getInitializer() != null) {
                initializer = this.mapper.getNodeID((ASTNode)fragment.getInitializer());
            }
            String[] args = new String[]{id, parent, name, type, modifiers, extra_dimensions, initializer, unit};
            this.code.addFact(KEY, this.generateArgs(KEYS, args));
        }
        String new_id = this.generateList(fragments_nodes);
        this.mapper.setNodeID((ASTNode)node, new_id.substring(1, new_id.length() - 1));
    }

    @Override
    public void bind(FieldDeclaration node) {
        this.converter_factory.getConverter((ASTNode)node.getType()).bind(node.getType());
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        Vector fragments_nodes = new Vector();
        fragments_nodes.addAll(node.fragments());
        for (VariableDeclarationFragment fragment : fragments_nodes) {
            this.converter_factory.getConverter((ASTNode)fragment).bind(fragment);
        }
    }
}

