/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.InfixExpression;

public class InfixExpressionPrologConverter
extends NodeConverter<InfixExpression> {
    private static final String KEY = "infix_expression";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "parent";
        stringArray[2] = "operator";
        stringArray[3] = "left_operand";
        stringArray[4] = "right_operand";
        stringArray[5] = "extended_operands";
        stringArray[6] = "body_declaration";
        stringArray[7] = "type_declaration";
        stringArray[8] = "compilation_unit";
        KEYS = stringArray;
    }

    public InfixExpressionPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(InfixExpression node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String operator = this.quote(this.operator(node.getOperator().toString()));
        this.converter_factory.getConverter((ASTNode)node.getLeftOperand()).convert(node.getLeftOperand());
        String left_operand = this.mapper.getNodeID((ASTNode)node.getLeftOperand());
        this.converter_factory.getConverter((ASTNode)node.getRightOperand()).convert(node.getRightOperand());
        String right_operand = this.mapper.getNodeID((ASTNode)node.getRightOperand());
        Vector<ASTNode> extended_operand_nodes = new Vector<ASTNode>();
        extended_operand_nodes.addAll(node.extendedOperands());
        for (ASTNode extended_operand : extended_operand_nodes) {
            this.converter_factory.getConverter(extended_operand).convert(extended_operand);
        }
        String extended_operands = this.generateList(extended_operand_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, operator, left_operand, right_operand, extended_operands, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(InfixExpression node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getLeftOperand()).bind(node.getLeftOperand());
        this.converter_factory.getConverter((ASTNode)node.getRightOperand()).bind(node.getRightOperand());
        Vector extended_operand_nodes = new Vector();
        extended_operand_nodes.addAll(node.extendedOperands());
        for (ASTNode extended_operand : extended_operand_nodes) {
            this.converter_factory.getConverter(extended_operand).bind(extended_operand);
        }
    }
}

