/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;

public class BlockPrologConverter
extends NodeConverter<Block> {
    private static final String KEY = "block";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[6];
        stringArray[1] = "parent";
        stringArray[2] = "statements";
        stringArray[3] = "body_declaration";
        stringArray[4] = "type_declaration";
        stringArray[5] = "compilation_unit";
        KEYS = stringArray;
    }

    public BlockPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(Block node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        Vector<ASTNode> statements_nodes = new Vector<ASTNode>();
        statements_nodes.addAll(node.statements());
        for (ASTNode statement : statements_nodes) {
            this.converter_factory.getConverter(statement).convert(statement);
        }
        String statements = this.generateList(statements_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, statements, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(Block node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        Vector statements_nodes = new Vector();
        statements_nodes.addAll(node.statements());
        for (ASTNode statement : statements_nodes) {
            this.converter_factory.getConverter(statement).bind(statement);
        }
    }
}

