/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.LambdaExpression;

public class LambdaExpressionPrologConverter
extends NodeConverter<LambdaExpression> {
    private static final String KEY = "lambda_expression";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[7];
        stringArray[1] = "parent";
        stringArray[2] = "parameters";
        stringArray[3] = "body";
        stringArray[4] = "body_declaration";
        stringArray[5] = "type_declaration";
        stringArray[6] = "compilation_unit";
        KEYS = stringArray;
    }

    public LambdaExpressionPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(LambdaExpression node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        this.converter_factory.getConverter(node.getBody()).convert(node.getBody());
        String body = this.mapper.getNodeID(node.getBody());
        Vector<ASTNode> parameters_nodes = new Vector<ASTNode>();
        parameters_nodes.addAll(node.parameters());
        for (ASTNode parameter : parameters_nodes) {
            this.converter_factory.getConverter(parameter).convert(parameter);
        }
        String parameters = this.generateList(parameters_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, parameters, body, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(LambdaExpression node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter(node.getBody()).bind(node.getBody());
        Vector parameters_nodes = new Vector();
        parameters_nodes.addAll(node.parameters());
        for (ASTNode parameter : parameters_nodes) {
            this.converter_factory.getConverter(parameter).bind(parameter);
        }
    }
}

