/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class MethodDeclarationPrologConverter
extends NodeConverter<MethodDeclaration> {
    private static final String CONSTRUCTOR_KEY = "constructor_declaration";
    private static final String METHOD_KEY = "method_declaration";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "parent";
        stringArray[3] = "modifiers";
        stringArray[4] = "parameters";
        stringArray[5] = "parameters_types";
        stringArray[6] = "return_type";
        stringArray[7] = "dimensions";
        stringArray[8] = "body";
        stringArray[9] = "exceptions";
        stringArray[10] = "compilation_unit";
        KEYS = stringArray;
    }

    public MethodDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(MethodDeclaration node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String fact = node.isConstructor() ? CONSTRUCTOR_KEY : METHOD_KEY;
        String name = this.quote(node.getName().toString());
        Vector<ASTNode> parameters_nodes = new Vector<ASTNode>();
        Vector<ASTNode> parameters_types_nodes = new Vector<ASTNode>();
        parameters_nodes.addAll(node.parameters());
        for (ASTNode parameter : parameters_nodes) {
            this.converter_factory.getConverter(parameter).convert(parameter);
            parameters_types_nodes.add((ASTNode)((SingleVariableDeclaration)parameter).getType());
        }
        String parameters = this.generateList(parameters_nodes);
        String parameters_types = this.generateList(parameters_types_nodes);
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        String body_id = null;
        if (node.getBody() != null) {
            this.converter_factory.getConverter((ASTNode)node.getBody()).convert(node.getBody());
            body_id = this.mapper.getNodeID((ASTNode)node.getBody());
        }
        String return_type = null;
        if (node.getReturnType2() != null) {
            this.converter_factory.getConverter((ASTNode)node.getReturnType2()).convert(node.getReturnType2());
            return_type = this.mapper.getNodeID((ASTNode)node.getReturnType2());
        }
        if (node.isConstructor()) {
            return_type = this.mapper.getNodeID(node.getParent());
        }
        String dimensions = Integer.toString(node.getExtraDimensions());
        Vector<ASTNode> exceptions_nodes = new Vector<ASTNode>();
        exceptions_nodes.addAll(node.thrownExceptionTypes());
        for (ASTNode exception_type : exceptions_nodes) {
            this.converter_factory.getConverter(exception_type).convert(exception_type);
        }
        String exceptions_ids = this.generateList(exceptions_nodes);
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, name, modifiers, parameters, parameters_types, return_type, dimensions, body_id, exceptions_ids, unit};
        this.code.addFact(fact, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(MethodDeclaration node) {
        this.mapper.setBindingID((IBinding)node.resolveBinding(), this.mapper.getNodeID((ASTNode)node));
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        Vector parameters_nodes = new Vector();
        Vector<Type> arguments_types = new Vector<Type>();
        parameters_nodes.addAll(node.parameters());
        for (SingleVariableDeclaration singleVariableDeclaration : parameters_nodes) {
            this.converter_factory.getConverter((ASTNode)singleVariableDeclaration).bind(singleVariableDeclaration);
            arguments_types.add(singleVariableDeclaration.getType());
        }
        for (ASTNode aSTNode : arguments_types) {
            this.converter_factory.getConverter(aSTNode).bind(aSTNode);
        }
        this.converter_factory.getConverter((ASTNode)node.getBody()).bind(node.getBody());
        if (node.getReturnType2() != null) {
            this.converter_factory.getConverter((ASTNode)node.getReturnType2()).bind(node.getReturnType2());
        }
        Vector vector = new Vector();
        vector.addAll(node.thrownExceptionTypes());
        for (ASTNode exception_type : vector) {
            this.converter_factory.getConverter(exception_type).bind(exception_type);
        }
    }

    @Override
    public String getName(MethodDeclaration node) {
        Vector<String> parameters = new Vector<String>();
        for (Object object : node.parameters()) {
            ASTNode parameter = (ASTNode)object;
            parameters.add(this.converter_factory.getConverter(parameter).getName(parameter));
        }
        String params = ((Object)parameters).toString();
        if (!parameters.isEmpty()) {
            params = params.substring(1, params.length() - 1);
        }
        String type = "";
        if (!node.isConstructor()) {
            type = this.converter_factory.getConverter((ASTNode)node.getReturnType2()).getName(node.getReturnType2());
        }
        return String.valueOf(type) + " " + node.getName().toString() + "(" + params + ")";
    }
}

