/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.api;

import ar.edu.unicen.isistan.si.soploon.server.client.SoploonClient;
import ar.edu.unicen.isistan.si.soploon.server.models.User;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.api.Synchronizer;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.storage.Configuration;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.storage.StorageManager;
import java.util.ArrayList;

public class Updater {
    private static Updater INSTANCE = null;
    public static final int NOT_FINISHED = 0;
    public static final int ERROR_CONNECTIVITY = -2;
    public static final int ERROR_STORING = -3;
    public static final int UPDATED = 1;
    public static final int NOT_UPDATED = 2;
    private SoploonClient client;
    private StorageManager storageManager = StorageManager.getInstance();
    private boolean ready;

    private Updater() {
        User user = this.storageManager.getData().getUser();
        if (user != null) {
            this.client = new SoploonClient("https://si.isistan.unicen.edu.ar/soploon/api", user);
        }
        this.ready = user != null;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public static synchronized Updater getInstance() {
        if (INSTANCE != null && !INSTANCE.isReady()) {
            INSTANCE = null;
        }
        if (INSTANCE == null) {
            INSTANCE = new Updater();
        }
        return INSTANCE;
    }

    public synchronized int update() {
        if (!this.ready) {
            Synchronizer.getInstance().sync();
            User user = this.storageManager.getData().getUser();
            if (user != null) {
                this.client = new SoploonClient("https://si.isistan.unicen.edu.ar/soploon/api", user);
            }
            boolean bl = this.ready = user != null;
        }
        if (this.ready) {
            this.client.authenticate();
            ArrayList rules = this.client.getRules();
            ArrayList predicates = this.client.getPredicates();
            if (rules != null && predicates != null) {
                Configuration configuration = new Configuration();
                configuration.setRules(rules);
                configuration.setPredicates(predicates);
                Configuration currentConfiguration = this.storageManager.getConfiguration();
                if (!configuration.equals(currentConfiguration)) {
                    return this.storageManager.storeConfiguration(configuration) ? 1 : -3;
                }
                return 2;
            }
            return -2;
        }
        return -2;
    }
}

