/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.eclipse.views;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.bugs.Bug;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.bugs.BuggedCode;
import java.awt.Desktop;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CorrectionsView
extends ViewPart {
    public static final String ID = "TeachingAssistant.corrections";
    private TreeViewer viewer;
    private List<TreeViewerColumn> columns;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 68354);
        this.createColumns(this.viewer);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "plugin.viewer");
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                if (selectedNode == null) {
                    return;
                }
                if (selectedNode instanceof Bug) {
                    ((Bug)selectedNode).open();
                } else if (selectedNode instanceof BuggedCode) {
                    ((BuggedCode)selectedNode).open();
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String uri;
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                if (selectedNode == null) {
                    return;
                }
                if (selectedNode instanceof Bug && (uri = ((Bug)selectedNode).getRule().getLink()) != null) {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            desktop.browse(new URI(uri));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                Bug bug;
                if (parentElement instanceof Bug && !(bug = (Bug)parentElement).isSimple()) {
                    return bug.getBuggedCodes().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof BuggedCode) {
                    return ((BuggedCode)element).getBug();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element) != null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private void createColumns(TreeViewer viewer) {
        this.columns = new Vector<TreeViewerColumn>();
        TreeViewerColumn col = new TreeViewerColumn(viewer, 0);
        col.getColumn().setText("Correccion");
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Bug) {
                    return ((Bug)element).getType();
                }
                return "";
            }
        });
        this.columns.add(col);
        col = new TreeViewerColumn(viewer, 0);
        col.getColumn().setText("Archivo");
        col.getColumn().setAlignment(0x1000000);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Bug) {
                    Bug bug = (Bug)element;
                    if (bug.isSimple()) {
                        return bug.getFile();
                    }
                } else if (element instanceof BuggedCode) {
                    return ((BuggedCode)element).getFile();
                }
                return "";
            }
        });
        this.columns.add(col);
        col = new TreeViewerColumn(viewer, 0);
        col.getColumn().setText("Linea");
        col.getColumn().setAlignment(0x1000000);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Bug) {
                    Bug bug = (Bug)element;
                    if (bug.isSimple()) {
                        return bug.getLineNumber();
                    }
                } else if (element instanceof BuggedCode) {
                    return ((BuggedCode)element).getLineNumber();
                }
                return "";
            }
        });
        this.columns.add(col);
        col = new TreeViewerColumn(viewer, 0);
        col.getColumn().setText("Codigo");
        col.getColumn().setAlignment(0x1000000);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Bug) {
                    Bug bug = (Bug)element;
                    if (bug.isSimple()) {
                        return bug.getCode();
                    }
                } else if (element instanceof BuggedCode) {
                    return ((BuggedCode)element).getCode();
                }
                return "";
            }
        });
        this.columns.add(col);
        col = new TreeViewerColumn(viewer, 0);
        col.getColumn().setWidth(500);
        col.getColumn().setText("Descripcion");
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Bug) {
                    return ((Bug)element).getDescription();
                }
                return "";
            }
        });
        this.columns.add(col);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setBugs(List<Bug> bugs) {
        Collections.sort(bugs);
        this.viewer.setInput(bugs);
        this.viewer.refresh();
        for (TreeViewerColumn column : this.columns) {
            column.getColumn().pack();
        }
        TreeViewerColumn codecol = this.columns.get(3);
        if (codecol.getColumn().getWidth() > 350) {
            codecol.getColumn().setWidth(350);
        }
    }
}

