/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import ar.edu.unicen.isistan.si.soploon.server.models.Error;
import ar.edu.unicen.isistan.si.soploon.server.models.Predicate;
import ar.edu.unicen.isistan.si.soploon.server.models.Rule;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.storage.Configuration;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.storage.StorageManager;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.PrologPredicate;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.PrologRule;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.RuleRunnable;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.analyzer.bugs.Bug;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrologAnalyzer {
    private static final String MONITOR_TITLE = "Buscando errores";
    private static final String MONITOR_TITLE_PRE = "Preparando analisis";
    private List<PrologRule> rules;
    private List<PrologPredicate> predicates;
    private List<Bug> bugs = new ArrayList<Bug>();

    public PrologAnalyzer() {
        this.rules = new ArrayList<PrologRule>();
        this.predicates = new ArrayList<PrologPredicate>();
    }

    public List<Bug> getBugs() {
        return this.bugs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int process(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory, IProgressMonitor monitor) {
        this.bugs.clear();
        this.prepare();
        try {
            boolean bl;
            Theory code_theory = new Theory(code.toString());
            String rules_predicates = new String();
            Vector<PrologRule> rules = new Vector<PrologRule>();
            for (PrologRule rule : this.rules) {
                if (!rule.isActivated()) continue;
                rules.add(rule);
                rules_predicates = String.valueOf(rules_predicates) + rule.getPredicates() + System.lineSeparator();
            }
            String auxiliary_predicates = new String();
            for (PrologPredicate predicate : this.predicates) {
                if (!predicate.isActivated()) continue;
                auxiliary_predicates = String.valueOf(auxiliary_predicates) + predicate.getCode() + System.lineSeparator();
            }
            Theory rule_theory = new Theory(rules_predicates);
            Theory auxiliary_theory = new Theory(auxiliary_predicates);
            int cores = Runtime.getRuntime().availableProcessors();
            Vector<RuleRunnable> runnables = new Vector<RuleRunnable>();
            monitor.beginTask(MONITOR_TITLE_PRE, cores);
            int i = 0;
            while (i < cores) {
                Prolog prolog = new Prolog();
                prolog.addTheory(rule_theory);
                prolog.addTheory(auxiliary_theory);
                prolog.addTheory(code_theory);
                runnables.add(new RuleRunnable(monitor, prolog, mapper, converter_factory, rules, this.bugs));
                monitor.worked(1);
                ++i;
            }
            ExecutorService thread_pool = Executors.newFixedThreadPool(cores);
            monitor.beginTask(MONITOR_TITLE, this.rules.size());
            for (Runnable runnable : runnables) {
                thread_pool.submit(runnable);
            }
            boolean bl2 = true;
            thread_pool.shutdown();
            while (bl) {
                try {
                    if (thread_pool.awaitTermination(2L, TimeUnit.SECONDS)) {
                        return 0;
                    }
                    if (!monitor.isCanceled()) continue;
                    thread_pool.shutdownNow();
                    monitor.done();
                    return 1;
                }
                catch (InterruptedException interruptedException) {
                    thread_pool.shutdownNow();
                    monitor.done();
                    return -1;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            monitor.done();
            return -1;
        }
    }

    public String validateProlog(String code) {
        try {
            Prolog engine = new Prolog();
            engine.addTheory(new Theory(code));
            return null;
        }
        catch (InvalidTheoryException e) {
            return e.getMessage();
        }
    }

    public ArrayList<Error> toErrors() {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (Bug bug : this.bugs) {
            errors.add(bug.toError());
        }
        return errors;
    }

    private void prepare() {
        Configuration configuration = StorageManager.getInstance().getConfiguration();
        this.rules.clear();
        for (Rule rule : configuration.getRules()) {
            this.rules.add(new PrologRule(rule));
        }
        this.predicates.clear();
        for (Predicate predicate : configuration.getPredicates()) {
            this.predicates.add(new PrologPredicate(predicate));
        }
    }

    public HashMap<Integer, Integer> rulesVersions() {
        HashMap<Integer, Integer> out = new HashMap<Integer, Integer>();
        for (PrologRule rule : this.rules) {
            if (!rule.isActivated()) continue;
            out.put(rule.getId(), rule.getVersion());
        }
        return out;
    }

    public HashMap<Integer, Integer> predicatesVersions() {
        HashMap<Integer, Integer> out = new HashMap<Integer, Integer>();
        for (PrologPredicate predicate : this.predicates) {
            if (!predicate.isActivated()) continue;
            out.put(predicate.getId(), predicate.getVersion());
        }
        return out;
    }
}

