/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.TryStatement;

public class TryStatementPrologConverter
extends NodeConverter<TryStatement> {
    private static final String KEY = "try_statement";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "parent";
        stringArray[2] = "resources";
        stringArray[3] = "body";
        stringArray[4] = "catchs";
        stringArray[5] = "finally";
        stringArray[6] = "body_declaration";
        stringArray[7] = "type_declaration";
        stringArray[8] = "compilation_unit";
        KEYS = stringArray;
    }

    public TryStatementPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(TryStatement node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent_id = this.mapper.getNodeID(node.getParent());
        this.converter_factory.getConverter((ASTNode)node.getBody()).convert(node.getBody());
        String body = this.mapper.getNodeID((ASTNode)node.getBody());
        Vector<ASTNode> resources_nodes = new Vector<ASTNode>();
        resources_nodes.addAll(node.resources());
        for (ASTNode resource : resources_nodes) {
            this.converter_factory.getConverter(resource).convert(resource);
        }
        String resources = this.generateList(resources_nodes);
        Vector<ASTNode> catchs_nodes = new Vector<ASTNode>();
        catchs_nodes.addAll(node.catchClauses());
        for (ASTNode catch_node : catchs_nodes) {
            this.converter_factory.getConverter(catch_node).convert(catch_node);
        }
        String catchs = this.generateList(catchs_nodes);
        this.converter_factory.getConverter((ASTNode)node.getFinally()).convert(node.getFinally());
        String finally_body = this.mapper.getNodeID((ASTNode)node.getFinally());
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent_id, resources, body, catchs, finally_body, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(TryStatement node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getBody()).bind(node.getBody());
        Vector resources_nodes = new Vector();
        resources_nodes.addAll(node.resources());
        for (ASTNode resource : resources_nodes) {
            this.converter_factory.getConverter(resource).bind(resource);
        }
        Vector catchs_nodes = new Vector();
        catchs_nodes.addAll(node.catchClauses());
        for (ASTNode catch_node : catchs_nodes) {
            this.converter_factory.getConverter(catch_node).bind(catch_node);
        }
        this.converter_factory.getConverter((ASTNode)node.getFinally()).bind(node.getFinally());
    }
}

